// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Idhttp.pas' rev: 10.00

#ifndef IdhttpHPP
#define IdhttpHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Idexception.hpp>	// Pascal unit
#include <Idexceptioncore.hpp>	// Pascal unit
#include <Idassignednumbers.hpp>	// Pascal unit
#include <Idheaderlist.hpp>	// Pascal unit
#include <Idhttpheaderinfo.hpp>	// Pascal unit
#include <Idreplyrfc.hpp>	// Pascal unit
#include <Idssl.hpp>	// Pascal unit
#include <Idzlibcompressorbase.hpp>	// Pascal unit
#include <Idtcpclient.hpp>	// Pascal unit
#include <Iduri.hpp>	// Pascal unit
#include <Idcookie.hpp>	// Pascal unit
#include <Idcookiemanager.hpp>	// Pascal unit
#include <Idauthentication.hpp>	// Pascal unit
#include <Idauthenticationmanager.hpp>	// Pascal unit
#include <Idmultipartformdata.hpp>	// Pascal unit
#include <Idglobal.hpp>	// Pascal unit
#include <Idsys.hpp>	// Pascal unit
#include <Idobjs.hpp>	// Pascal unit
#include <Idbasecomponent.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Idtcpconnection.hpp>	// Pascal unit
#include <Idcomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Idhttp
{
//-- type declarations -------------------------------------------------------
typedef AnsiString TIdHTTPMethod;

#pragma option push -b-
enum TIdHTTPWhatsNext { wnGoToURL, wnJustExit, wnDontKnow, wnReadAndGo, wnAuthRequest };
#pragma option pop

#pragma option push -b-
enum TIdHTTPConnectionType { ctNormal, ctSSL, ctProxy, ctSSLProxy };
#pragma option pop

#pragma option push -b-
enum TIdHTTPOption { hoInProcessAuth, hoKeepOrigProtocol, hoForceEncodeParams };
#pragma option pop

typedef Set<TIdHTTPOption, hoInProcessAuth, hoForceEncodeParams>  TIdHTTPOptions;

#pragma option push -b-
enum TIdHTTPProtocolVersion { pv1_0, pv1_1 };
#pragma option pop

typedef void __fastcall (__closure *TIdHTTPOnRedirectEvent)(System::TObject* Sender, AnsiString &dest, int &NumRedirect, bool &Handled, AnsiString &VMethod);

typedef void __fastcall (__closure *TIdHTTPOnHeadersAvailable)(System::TObject* Sender, Idheaderlist::TIdHeaderList* AHeaders, bool &VContinue);

typedef void __fastcall (__closure *TIdOnSelectAuthorization)(System::TObject* Sender, TMetaClass* &AuthenticationClass, Idheaderlist::TIdHeaderList* AuthInfo);

typedef void __fastcall (__closure *TIdOnAuthorization)(System::TObject* Sender, Idauthentication::TIdAuthentication* Authentication, bool &Handled);

class DELPHICLASS TIdHTTPResponse;
class DELPHICLASS TIdCustomHTTP;
class DELPHICLASS TIdHTTPProtocol;
class DELPHICLASS TIdHTTPRequest;
class PASCALIMPLEMENTATION TIdHTTPRequest : public Idhttpheaderinfo::TIdRequestHeaderInfo 
{
	typedef Idhttpheaderinfo::TIdRequestHeaderInfo inherited;
	
protected:
	TIdCustomHTTP* FHTTP;
	AnsiString FURL;
	AnsiString FMethod;
	Classes::TStream* FSourceStream;
	TIdHTTPConnectionType FUseProxy;
	Idglobal::TIdIPVersion FIPVersion;
	
public:
	__fastcall virtual TIdHTTPRequest(TIdCustomHTTP* AHTTP);
	__property AnsiString URL = {read=FURL, write=FURL};
	__property AnsiString Method = {read=FMethod, write=FMethod};
	__property Classes::TStream* Source = {read=FSourceStream, write=FSourceStream};
	__property TIdHTTPConnectionType UseProxy = {read=FUseProxy, nodefault};
	__property Idglobal::TIdIPVersion IPVersion = {read=FIPVersion, write=FIPVersion, nodefault};
public:
	#pragma option push -w-inl
	/* TIdRequestHeaderInfo.Destroy */ inline __fastcall virtual ~TIdHTTPRequest(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdHTTPProtocol : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	TIdCustomHTTP* FHTTP;
	int FResponseCode;
	TIdHTTPRequest* FRequest;
	TIdHTTPResponse* FResponse;
	__fastcall TIdHTTPProtocol(TIdCustomHTTP* AConnection);
	__fastcall virtual ~TIdHTTPProtocol(void);
	TIdHTTPWhatsNext __fastcall ProcessResponse(short * AIgnoreReplies, const int AIgnoreReplies_Size);
	void __fastcall BuildAndSendRequest(Iduri::TIdURI* AURI);
	void __fastcall RetrieveHeaders(int AMaxHeaderCount);
	__property int ResponseCode = {read=FResponseCode, nodefault};
	__property TIdHTTPRequest* Request = {read=FRequest};
	__property TIdHTTPResponse* Response = {read=FResponse};
};


class PASCALIMPLEMENTATION TIdCustomHTTP : public Idtcpclient::TIdTCPClientCustom 
{
	typedef Idtcpclient::TIdTCPClientCustom inherited;
	
protected:
	int FAuthRetries;
	int FAuthProxyRetries;
	Idcookiemanager::TIdCookieManager* FCookieManager;
	Idzlibcompressorbase::TIdZLibCompressorBase* FCompressor;
	bool FFreeOnDestroy;
	int FMaxAuthRetries;
	int FMaxHeaderLines;
	bool FAllowCookies;
	Idauthenticationmanager::TIdAuthenticationManager* FAuthenticationManager;
	TIdHTTPProtocolVersion FProtocolVersion;
	int FRedirectCount;
	int FRedirectMax;
	bool FHandleRedirects;
	TIdHTTPOptions FOptions;
	Iduri::TIdURI* FURI;
	TIdHTTPProtocol* FHTTPProto;
	Idhttpheaderinfo::TIdProxyConnectionInfo* FProxyParameters;
	TIdHTTPOnHeadersAvailable FOnHeadersAvailable;
	TIdHTTPOnRedirectEvent FOnRedirect;
	TIdOnSelectAuthorization FOnSelectAuthorization;
	TIdOnSelectAuthorization FOnSelectProxyAuthorization;
	TIdOnAuthorization FOnAuthorization;
	TIdOnAuthorization FOnProxyAuthorization;
	virtual void __fastcall DoRequest(const AnsiString AMethod, AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent, short * AIgnoreReplies, const int AIgnoreReplies_Size);
	virtual void __fastcall InitComponent(void);
	void __fastcall SetAuthenticationManager(Idauthenticationmanager::TIdAuthenticationManager* Value);
	void __fastcall SetCookieManager(Idcookiemanager::TIdCookieManager* ACookieManager);
	void __fastcall SetAllowCookies(bool AValue);
	int __fastcall GetResponseCode(void);
	AnsiString __fastcall GetResponseText();
	virtual bool __fastcall DoOnAuthorization(TIdHTTPRequest* ARequest, TIdHTTPResponse* AResponse);
	virtual bool __fastcall DoOnProxyAuthorization(TIdHTTPRequest* ARequest, TIdHTTPResponse* AResponse);
	virtual bool __fastcall DoOnRedirect(AnsiString &Location, AnsiString &VMethod, int RedirectCount);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	void __fastcall ProcessCookies(TIdHTTPRequest* ARequest, TIdHTTPResponse* AResponse);
	TIdHTTPConnectionType __fastcall SetHostAndPort(void);
	void __fastcall SetCookies(Iduri::TIdURI* AURL, TIdHTTPRequest* ARequest);
	void __fastcall ReadResult(TIdHTTPResponse* AResponse);
	void __fastcall PrepareRequest(TIdHTTPRequest* ARequest);
	void __fastcall ConnectToHost(TIdHTTPRequest* ARequest, TIdHTTPResponse* AResponse);
	TIdHTTPResponse* __fastcall GetResponseHeaders(void);
	TIdHTTPRequest* __fastcall GetRequestHeaders(void);
	void __fastcall SetRequestHeaders(TIdHTTPRequest* Value);
	void __fastcall EncodeRequestParams(Classes::TStrings* AStrings);
	AnsiString __fastcall SetRequestParams(Classes::TStrings* AStrings);
	void __fastcall CheckAndConnect(TIdHTTPResponse* AResponse);
	virtual void __fastcall DoOnDisconnected(void);
	
public:
	__fastcall virtual ~TIdCustomHTTP(void);
	void __fastcall Options(AnsiString AURL)/* overload */;
	void __fastcall Get(AnsiString AURL, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Get(AnsiString AURL, Classes::TStream* AResponseContent, short * AIgnoreReplies, const int AIgnoreReplies_Size)/* overload */;
	AnsiString __fastcall Get(AnsiString AURL)/* overload */;
	AnsiString __fastcall Get(AnsiString AURL, short * AIgnoreReplies, const int AIgnoreReplies_Size)/* overload */;
	void __fastcall Trace(AnsiString AURL, Classes::TStream* AResponseContent)/* overload */;
	AnsiString __fastcall Trace(AnsiString AURL)/* overload */;
	void __fastcall Head(AnsiString AURL);
	AnsiString __fastcall Post(AnsiString AURL, Classes::TStrings* ASource)/* overload */;
	AnsiString __fastcall Post(AnsiString AURL, Classes::TStream* ASource)/* overload */;
	AnsiString __fastcall Post(AnsiString AURL, Idmultipartformdata::TIdMultiPartFormDataStream* ASource)/* overload */;
	void __fastcall Post(AnsiString AURL, Idmultipartformdata::TIdMultiPartFormDataStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Post(AnsiString AURL, Classes::TStrings* ASource, Classes::TStream* AResponseContent)/* overload */;
	void __fastcall Post(AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	AnsiString __fastcall Put(AnsiString AURL, Classes::TStream* ASource)/* overload */;
	void __fastcall Put(AnsiString AURL, Classes::TStream* ASource, Classes::TStream* AResponseContent)/* overload */;
	__property Idzlibcompressorbase::TIdZLibCompressorBase* Compressor = {read=FCompressor, write=FCompressor};
	__property int ResponseCode = {read=GetResponseCode, nodefault};
	__property AnsiString ResponseText = {read=GetResponseText};
	__property TIdHTTPResponse* Response = {read=GetResponseHeaders};
	__property Iduri::TIdURI* URL = {read=FURI};
	__property int AuthRetries = {read=FAuthRetries, nodefault};
	__property int AuthProxyRetries = {read=FAuthProxyRetries, nodefault};
	__property int MaxAuthRetries = {read=FMaxAuthRetries, write=FMaxAuthRetries, default=3};
	__property bool AllowCookies = {read=FAllowCookies, write=SetAllowCookies, nodefault};
	__property bool HandleRedirects = {read=FHandleRedirects, write=FHandleRedirects, default=0};
	__property int RedirectCount = {read=FRedirectCount, nodefault};
	__property int RedirectMaximum = {read=FRedirectMax, write=FRedirectMax, default=15};
	__property TIdHTTPProtocolVersion ProtocolVersion = {read=FProtocolVersion, write=FProtocolVersion, default=1};
	__property int MaxHeaderLines = {read=FMaxHeaderLines, write=FMaxHeaderLines, default=255};
	__property Idhttpheaderinfo::TIdProxyConnectionInfo* ProxyParams = {read=FProxyParameters, write=FProxyParameters};
	__property TIdHTTPRequest* Request = {read=GetRequestHeaders, write=SetRequestHeaders};
	__property TIdHTTPOptions HTTPOptions = {read=FOptions, write=FOptions, nodefault};
	__property TIdHTTPOnHeadersAvailable OnHeadersAvailable = {read=FOnHeadersAvailable, write=FOnHeadersAvailable};
	__property TIdHTTPOnRedirectEvent OnRedirect = {read=FOnRedirect, write=FOnRedirect};
	__property TIdOnSelectAuthorization OnSelectAuthorization = {read=FOnSelectAuthorization, write=FOnSelectAuthorization};
	__property TIdOnSelectAuthorization OnSelectProxyAuthorization = {read=FOnSelectProxyAuthorization, write=FOnSelectProxyAuthorization};
	__property TIdOnAuthorization OnAuthorization = {read=FOnAuthorization, write=FOnAuthorization};
	__property TIdOnAuthorization OnProxyAuthorization = {read=FOnProxyAuthorization, write=FOnProxyAuthorization};
	__property Idcookiemanager::TIdCookieManager* CookieManager = {read=FCookieManager, write=SetCookieManager};
	__property Idauthenticationmanager::TIdAuthenticationManager* AuthenticationManager = {read=FAuthenticationManager, write=SetAuthenticationManager};
public:
	#pragma option push -w-inl
	/* TIdBaseComponent.Create */ inline __fastcall TIdCustomHTTP(Classes::TComponent* AOwner)/* overload */ : Idtcpclient::TIdTCPClientCustom(AOwner) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TIdHTTPResponse : public Idhttpheaderinfo::TIdResponseHeaderInfo 
{
	typedef Idhttpheaderinfo::TIdResponseHeaderInfo inherited;
	
protected:
	TIdCustomHTTP* FHTTP;
	int FResponseCode;
	AnsiString FResponseText;
	bool FKeepAlive;
	Classes::TStream* FContentStream;
	TIdHTTPProtocolVersion FResponseVersion;
	bool __fastcall GetKeepAlive(void);
	int __fastcall GetResponseCode(void);
	
public:
	__fastcall virtual TIdHTTPResponse(TIdCustomHTTP* AParent);
	__property bool KeepAlive = {read=GetKeepAlive, write=FKeepAlive, nodefault};
	__property AnsiString ResponseText = {read=FResponseText, write=FResponseText};
	__property int ResponseCode = {read=GetResponseCode, write=FResponseCode, nodefault};
	__property TIdHTTPProtocolVersion ResponseVersion = {read=FResponseVersion, write=FResponseVersion, nodefault};
	__property Classes::TStream* ContentStream = {read=FContentStream, write=FContentStream};
public:
	#pragma option push -w-inl
	/* TIdResponseHeaderInfo.Destroy */ inline __fastcall virtual ~TIdHTTPResponse(void) { }
	#pragma option pop
	
};


class DELPHICLASS TIdHTTP;
class PASCALIMPLEMENTATION TIdHTTP : public TIdCustomHTTP 
{
	typedef TIdCustomHTTP inherited;
	
__published:
	__property MaxAuthRetries  = {default=3};
	__property AllowCookies ;
	__property HandleRedirects  = {default=0};
	__property ProtocolVersion  = {default=1};
	__property RedirectMaximum  = {default=15};
	__property ProxyParams ;
	__property Request ;
	__property HTTPOptions ;
	__property OnHeadersAvailable ;
	__property OnRedirect ;
	__property OnSelectAuthorization ;
	__property OnSelectProxyAuthorization ;
	__property OnAuthorization ;
	__property OnProxyAuthorization ;
	__property CookieManager ;
	__property Compressor ;
public:
	#pragma option push -w-inl
	/* TIdCustomHTTP.Destroy */ inline __fastcall virtual ~TIdHTTP(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TIdBaseComponent.Create */ inline __fastcall TIdHTTP(Classes::TComponent* AOwner)/* overload */ : TIdCustomHTTP(AOwner) { }
	#pragma option pop
	
};


class DELPHICLASS EIdUnknownProtocol;
class PASCALIMPLEMENTATION EIdUnknownProtocol : public Idexception::EIdException 
{
	typedef Idexception::EIdException inherited;
	
public:
	#pragma option push -w-inl
	/* EIdException.Create */ inline __fastcall virtual EIdUnknownProtocol(AnsiString AMsg)/* overload */ : Idexception::EIdException(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Idexception::EIdException(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdUnknownProtocol(int Ident)/* overload */ : Idexception::EIdException(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdUnknownProtocol(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Idexception::EIdException(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, int AHelpContext) : Idexception::EIdException(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdUnknownProtocol(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Idexception::EIdException(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdUnknownProtocol(int Ident, int AHelpContext)/* overload */ : Idexception::EIdException(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdUnknownProtocol(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Idexception::EIdException(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdUnknownProtocol(void) { }
	#pragma option pop
	
};


class DELPHICLASS EIdHTTPProtocolException;
class PASCALIMPLEMENTATION EIdHTTPProtocolException : public Idreplyrfc::EIdReplyRFCError 
{
	typedef Idreplyrfc::EIdReplyRFCError inherited;
	
protected:
	AnsiString FErrorMessage;
	
public:
	__fastcall virtual EIdHTTPProtocolException(const int anErrCode, const AnsiString asReplyMessage, const AnsiString asErrorMessage);
	__property AnsiString ErrorMessage = {read=FErrorMessage};
public:
	#pragma option push -w-inl
	/* EIdException.Create */ inline __fastcall virtual EIdHTTPProtocolException(AnsiString AMsg)/* overload */ : Idreplyrfc::EIdReplyRFCError(AMsg) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EIdHTTPProtocolException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size) : Idreplyrfc::EIdReplyRFCError(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EIdHTTPProtocolException(int Ident)/* overload */ : Idreplyrfc::EIdReplyRFCError(Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EIdHTTPProtocolException(int Ident, System::TVarRec const * Args, const int Args_Size)/* overload */ : Idreplyrfc::EIdReplyRFCError(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EIdHTTPProtocolException(const AnsiString Msg, int AHelpContext) : Idreplyrfc::EIdReplyRFCError(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EIdHTTPProtocolException(const AnsiString Msg, System::TVarRec const * Args, const int Args_Size, int AHelpContext) : Idreplyrfc::EIdReplyRFCError(Msg, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EIdHTTPProtocolException(int Ident, int AHelpContext)/* overload */ : Idreplyrfc::EIdReplyRFCError(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EIdHTTPProtocolException(System::PResStringRec ResStringRec, System::TVarRec const * Args, const int Args_Size, int AHelpContext)/* overload */ : Idreplyrfc::EIdReplyRFCError(ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EIdHTTPProtocolException(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
#define Id_HTTPMethodHead "HEAD"
#define Id_HTTPMethodGet "GET"
#define Id_HTTPMethodPost "POST"
#define Id_HTTPMethodOptions "OPTIONS"
#define Id_HTTPMethodTrace "TRACE"
#define Id_HTTPMethodPut "PUT"
#define Id_HTTPMethodDelete "DELETE"
#define Id_HTTPMethodConnect "CONNECT"
#define Id_TIdHTTP_ProtocolVersion (TIdHTTPProtocolVersion)(1)
static const Shortint Id_TIdHTTP_RedirectMax = 0xf;
static const Byte Id_TIdHTTP_MaxHeaderLines = 0xff;
static const bool Id_TIdHTTP_HandleRedirects = false;
static const Shortint Id_TIdHTTP_MaxAuthRetries = 0x3;

}	/* namespace Idhttp */
using namespace Idhttp;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Idhttp
